<?php $__env->startSection('title', 'View Doctor'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Doctor Details</h1>
    <div>
        <a href="<?php echo e(route('admin.doctors.edit', $doctor)); ?>" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="<?php echo e(route('admin.doctors.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-4 text-center">
                <?php if($doctor->image): ?>
                    <img src="<?php echo e(asset('storage/' . $doctor->image)); ?>" alt="<?php echo e($doctor->name); ?>" class="img-fluid rounded mb-3" style="max-width: 300px;">
                <?php else: ?>
                    <i class="bi bi-person-circle" style="font-size: 200px; color: #ccc;"></i>
                <?php endif; ?>
            </div>
            <div class="col-md-8">
                <h2><?php echo e($doctor->name); ?></h2>
                <p class="text-primary fs-5"><strong><?php echo e($doctor->specialization); ?></strong></p>
                <p class="text-muted"><?php echo e($doctor->credentials); ?></p>
                <?php if($doctor->bio): ?>
                <p><?php echo e($doctor->bio); ?></p>
                <?php endif; ?>
                <p><strong>Experience:</strong> <?php echo e($doctor->experience_years); ?> years</p>
                <p>
                    <strong>Status:</strong> 
                    <span class="badge bg-<?php echo e($doctor->is_active ? 'success' : 'secondary'); ?>">
                        <?php echo e($doctor->is_active ? 'Active' : 'Inactive'); ?>

                    </span>
                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ Websites/ENT Care/resources/views/admin/doctors/show.blade.php ENDPATH**/ ?>